<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

// Get Form Data
$name = $_POST['name'] ?? '';
$email = $_POST['email'] ?? '';
$phone = $_POST['phone'] ?? '';
$city = $_POST['city'] ?? '';
$state = $_POST['state'] ?? '';
$preferred_states = implode(', ', $_POST['preferred_states'] ?? []);
$truck_type = $_POST['truck_type'] ?? '';  // Removed implode()
$trailer_type = $_POST['trailer_type'] ?? '';  // Removed implode()
$weight = $_POST['weight'] ?? '';
$next_available_slot = $_POST['next_available_slot'] ?? '';  // Corrected field name
$mc_number = $_POST['mc_number'] ?? '';
$referral = $_POST['referral'] ?? '';
$service_agreement = isset($_POST['service_agreement']) ? 'Yes' : 'No';  // Corrected field name
$signature_consent = isset($_POST['signature_consent']) ? 'Yes' : 'No';  // Corrected field name
$signature_data = $_POST['signature_data'] ?? ''; // base64 canvas signature

// Admin Email Settings
$adminEmail = 'reviewer@pakalfa.com';
$fromEmail = 'reviewer@pakalfa.com';
$fromName = 'KeepTruckin Loads';
$subject = "New Carrier Registration - $name";

// Convert signature to file (if provided)
$signatureFile = '';
if (!empty($signature_data)) {
    $signature_data = str_replace('data:image/png;base64,', '', $signature_data);
    $signature_data = base64_decode($signature_data);
    $signatureFile = 'signature_' . time() . '.png';
    file_put_contents($signatureFile, $signature_data);
}

// Admin Email Body
$adminBody = "
New carrier registration received:

Name: $name
Email: $email
Phone: $phone
City: $city
State: $state
Preferred States: $preferred_states
Truck Type: $truck_type
Trailer Type: $trailer_type
Preferred Weight: $weight
Next Available Slot: $next_available_slot
MC Number: $mc_number
Referral Source: $referral
Consent to Contact: $signature_consent
Service Agreement Accepted: $service_agreement
";

// Client HTML Email
$clientBody = "
<html>
<head>
  <style>
    body { font-family: Arial, sans-serif; }
    .highlight { color: #e86822; font-weight: bold; }
  </style>
</head>
<body>
  <p>Hi <strong>$name</strong>,</p>
  <p>Thank you for registering with <strong>KeepTruckin Loads</strong>! 🚛<br>
  We’ve received your details and our team will get in touch soon.</p>

  <p><strong>Submitted Details:</strong></p>
  <ul>
    <li><strong>Email:</strong> $email</li>
    <li><strong>Phone:</strong> $phone</li>
    <li><strong>City:</strong> $city</li>
    <li><strong>State:</strong> $state</li>
    <li><strong>Preferred States:</strong> $preferred_states</li>
    <li><strong>Truck Type:</strong> $truck_type</li>
    <li><strong>Trailer Type:</strong> $trailer_type</li>
    <li><strong>Preferred Weight:</strong> $weight</li>
    <li><strong>Next Available Slot:</strong> $next_available_slot</li>
    <li><strong>MC Number:</strong> $mc_number</li>
  </ul>

  <p>We’re here to help you <strong>maximize your trucking profits</strong> and simplify your dispatching.</p>
  <p>Regards,<br><span class=\"highlight\">KeepTruckin Loads Team</span></p>
</body>
</html>
";

// Initialize PHPMailer
$mail = new PHPMailer(true);
try {
    $mail->isSMTP();
    $mail->Host = 'mail.pakalfa.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'reviewer@pakalfa.com';
    $mail->Password = 'Location@0310'; // use env variable in production
    $mail->SMTPSecure = 'ssl';
    $mail->Port = 465;

    $mail->setFrom($fromEmail, $fromName);

    // Send to Admin
    $mail->addAddress($adminEmail);
    $mail->Subject = $subject;
    $mail->Body = nl2br($adminBody);
    $mail->isHTML(true);

    // Attach Signature
    if ($signatureFile && file_exists($signatureFile)) {
        $mail->addAttachment($signatureFile);
    }

    // Attach Uploaded Files
    foreach ($_FILES['documents']['tmp_name'] as $key => $tmp_name) {
        $filename = $_FILES['documents']['name'][$key];
        $filetmp = $_FILES['documents']['tmp_name'][$key];
        if (is_uploaded_file($filetmp)) {
            $mail->addAttachment($filetmp, $filename);
        }
    }

    $mail->send();
    $mail->clearAddresses();
    $mail->clearAttachments();

    // Send to Client
    $mail->addAddress($email, $name);
    $mail->Subject = "Thank You - We've Received Your Info!";
    $mail->Body = $clientBody;
    $mail->isHTML(true);
    $mail->addAttachment('attachments/ServiceAgreement.pdf');
    $mail->send();

    echo "Form submitted successfully. Emails sent!";
} catch (Exception $e) {
    echo "Mailer Error: {$mail->ErrorInfo}";
}

// Delete temp signature file
if ($signatureFile && file_exists($signatureFile)) {
    unlink($signatureFile);
}
?>